<?php
/**
 * This file is part of FacturaScripts
 * Copyright (C) 2019-2023 Carlos Garcia Gomez <carlos@facturascripts.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

namespace FacturaScripts\Core\Model\Join;

use FacturaScripts\Core\Model\Base\JoinModel;
use FacturaScripts\Dinamic\Model\Asiento;
use FacturaScripts\Dinamic\Model\Partida;

/**
 * Description of PartidaAsiento
 *
 * @author Carlos Garcia Gomez              <carlos@facturascripts.com>
 * @author Jose Antonio Cuello Principal    <yopli2000@gmail.com>
 */
class PartidaAsiento extends JoinModel
{

    /**
     * @var Asiento
     */
    private $asiento;

    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->setMasterModel(new Partida());
        $this->asiento = new Asiento();
    }

    public function getPartida(): Partida
    {
        $partida = new Partida();
        $partida->load($this->idpartida);
        return $partida;
    }

    /**
     * Returns the url where to see / modify the data.
     *
     * @param string $type
     * @param string $list
     *
     * @return string
     */
    public function url(string $type = 'auto', string $list = 'List'): string
    {
        $this->asiento->idasiento = $this->idasiento;
        return $this->asiento->url($type, $list);
    }

    protected function getFields(): array
    {
        return [
            'baseimponible' => 'partidas.baseimponible',
            'canal' => 'asientos.canal',
            'concepto' => 'partidas.concepto',
            'debe' => 'partidas.debe',
            'fecha' => 'asientos.fecha',
            'haber' => 'partidas.haber',
            'idasiento' => 'partidas.idasiento',
            'idpartida' => 'partidas.idpartida',
            'iva' => 'partidas.iva',
            'numero' => 'asientos.numero',
            'punteada' => 'partidas.punteada',
            'saldo' => 'partidas.saldo'
        ];
    }

    protected function getSQLFrom(): string
    {
        return 'partidas LEFT JOIN asientos ON partidas.idasiento = asientos.idasiento';
    }

    protected function getTables(): array
    {
        return ['asientos', 'partidas'];
    }
}
